#include "StdV3D.h"
#include "BlobTorus.h"

namespace V3D {


BlobTorus::BlobTorus(float fCenterEnergy, const Vector3D& vcPos, float fInfluenceRange, float fLargeRadius /* = 1.f */, float fOpenAngle /* = 0.f */)
	: parent(fCenterEnergy, vcPos, fInfluenceRange), m_fLargeRadius(fLargeRadius), m_fOpenAngle(fOpenAngle)
{}

BlobTorus::~BlobTorus()
{}

bool BlobTorus::GetBlobBounds(Vector3D& /* vcBlobMin */, Vector3D& /* vcBlobMax */) const
{
	return false;
/*
	const float fBallRadius = m_fLargeRadius + 1.f / m_fInfluenceRangeInv;
	const Vector3D vcBoundBallHalfSize = Vector3D( fBallRadius, fBallRadius, fBallRadius);
	const Vector3D vcCenter = m_vcPosition;
	vcBlobMin = vcCenter; vcBlobMin -= vcBoundBallHalfSize;
	vcBlobMax = vcCenter; vcBlobMax += vcBoundBallHalfSize;
	return true;
*/
}


void BlobTorus::EnergyBaseShapeAddAtRectangle ( float* pafAddEnergies,    // Tableau des valeurs energetiques de la grille
										 const Vector3D& vcRectStart,  // Origine du rectangle
										 const Vector3D& vcRectAxisX,  // Axe X du rectangle (sert d'unite de separation entre deux calculs d'energie)
										 const Vector3D& vcRectAxisY,  // Axe Y du rectangle (sert d'unite de separation entre deux calculs d'energie)
                                         int32 nLinesCount,            // Nombre de subdivisions en Y dans le rectangle
										 int32 nLineLength,            // Nombre de subdivisions en X dans le rectangle
										 int32 nSizeX                  // Nombre de subdivisions en X dans la grille
										) const
{
	Vector3D vcStartCurLine = vcRectStart;
	for(int32 j = 0; j < nLinesCount; ++j, vcStartCurLine += vcRectAxisY)
	{
		int32 nFirstPointInLine = j * nSizeX;
		Vector3D vcCurPoint = vcStartCurLine;

		for(int32 i = 0; i < nLineLength; ++i)
		{
			if( ! BlobTorus::EarlyRejectBaseShapePoint(vcCurPoint) )
			{
				float fRadDivInflSqr = BlobTorus::GetBaseShapeSqrDist(vcCurPoint);
				if( fRadDivInflSqr < 1.f )
					pafAddEnergies[nFirstPointInLine+i] += EnergyNotZeroAtSqrDist(fRadDivInflSqr);
            }
			vcCurPoint += vcRectAxisX;
		}
	}
}







						/////////////////////////////



} // namespace


